( function( $ ) {
	var WidgetElements_RevealHandler = function( $scope, $ ) {
		var elementSettings = dceGetElementSettings( $scope );
		var rev1;
		var revealAction = function(){
			rev1 = new RevealFx(revealistance, {
				revealSettings : {
					bgcolor: elementSettings.reveal_bgcolor,
					direction: elementSettings.reveal_direction,
					duration: Number(elementSettings.reveal_speed.size)*100,
					delay: Number(elementSettings.reveal_delay.size)*100,
					onCover: function(contentEl, revealerEl) {
						contentEl.style.opacity = 1;
					}
				}
			});
		};
		var runReveal = function(){
			rev1.reveal();
		};
		if(elementSettings.enabled_reveal) {
			var revealId = '#reveal-' + $scope.data('id');
			var revealistance = document.querySelector(revealId);
		
			if (!jQuery(revealId).hasClass('block-revealer')) {
				revealAction();
			}

			var obsCallback = function(entries, observer) {
				entries.forEach(function(entry) {
					if (entry.isIntersecting) {
						runReveal();
						observer.unobserve(entry.target);
					}
				});
			};
		
			var observerOptions = {
				root: null,
				rootMargin: '0px',
				threshold: 1.0
			};

			var observer = new IntersectionObserver(obsCallback, observerOptions);
			observer.observe(revealistance);
		}		
	};

	$( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/global', WidgetElements_RevealHandler );
	} );
} )( jQuery );
